/*
 * EtHeadTracker2D.m 
 *
 * A 2D Head Tracker which provides real time head location and movment.
 * 
 * retrive an instance using the creation methods, or manually using alloc and 
 * then calling the setCaptureDevice.
 *
 * Use the various setter methods to fine tune the tracking.
 *
 * for more information please log to http://www.eyetwig.com
 * or contact support@eyetwig.com
 *
 * Copyright (c) 2000-2009 EyeTwig Inc. All rights reserved.
 *
 */

#import <Cocoa/Cocoa.h>
#import <QTKit/QTKit.h>
#import <QuartzCore/QuartzCore.h>

@class VideoDeviceCapture;
@class EtTracker;

//events
@interface NSObject (EtHeadTracker2DDelegate)
- (void) onHeadFound:(NSRect)headRect;
- (void) onHeadMoved:(float)dx dy:(float)dy;
- (void) onFrameReady:(CIImage*)frame;
@end


@interface EtHeadTracker2D : NSObject {

	VideoDeviceCapture* mVideoCapture;
	
	EtTracker* mTracker;
	
	NSMutableSet*	mDelegates;
	
	BOOL horizontalFlip;
	
	NSSize frameSize;
	
	int movmentAcceleration;
}



enum{
	EtTrackerNoMovmentAcceleration = 1,
	EtTrackerLowMovmentAcceleration = 5,
	EtTrackerMeduimMovmentAcceleration = 10,  /*Default*/
	EtTrackerHighMovmentAcceleration = 15
};



/* must be called before any other method*/
+ (EtHeadTracker2D*) initWithDefaultCaptureDevice:(NSSize)captureSize andDelegate:(id)delegate;
+ (EtHeadTracker2D*) initWithCaptureDevice:(QTCaptureDevice*)device withCaptureSize:(NSSize)captureSize andDelegate:(id)delegate;


/*listener must implement all 3 functions of EtHeadTrackerDelegate*/
- (void) flipHorizontal:(BOOL)flipFlag;
- (void) addEventListener:(id)listener;
- (void) setNoiseTolerance:(float)noiseThreshold;
- (void) setMovmentAcceleration:(int)acceleration;
- (BOOL) setCaptureDevice:(QTCaptureDevice*)device withCaptureSize:(NSSize)captureSize andDelegate:(id)delegate;
- (void) startTracking;
- (void) stopTracking;



@end



